<?php
/* --------------------------------------------------------------
   FetchedAllParcelServices.php 2020-03-30
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\ParcelService\Events;

use Gambio\Admin\ParcelService\Interfaces\ParcelServices;

/**
 * Class FetchedAllParcelServices
 *
 * @package Gambio\Admin\ParcelService\Events
 */
class FetchedAllParcelServices
{
    /**
     * @var ParcelServices
     */
    private $parcelServices;
    
    
    /**
     * FetchedAllParcelServicesEvent constructor.
     *
     * @param ParcelServices $parcelServices
     */
    private function __construct(ParcelServices $parcelServices)
    {
        $this->parcelServices = $parcelServices;
    }
    
    
    /**
     * @param ParcelServices $parcelServices
     *
     * @return FetchedAllParcelServices
     */
    public static function create(ParcelServices $parcelServices): FetchedAllParcelServices
    {
        return new self($parcelServices);
    }
    
    
    /**
     * @return ParcelServices
     */
    public function parcelServices(): ParcelServices
    {
        return $this->parcelServices;
    }
    
    
    /**
     * @param ParcelServices $parcelServices
     */
    public function replaceParcelServices(ParcelServices $parcelServices): void
    {
        $this->parcelServices = $parcelServices;
    }
}